-- ui screen events



function OnLoad ()
	SetProperty ("/LevelStart:enable_event_on_key_down", 1);
  CacheSound ("music/levelstart.ogg");
end;


timer = 0;
delay_time = 1.5;--3

function OnEnter ()
    SetProperty ("/LevelStart:enter_trans_duration", 0.75);
    SetProperty ("/LevelStart:leave_trans_duration", 0.75);
    
	-- get the required info to show here
	SetProperty ("level_short_name:label.text", "|000000|"..GetGameValue ("level_short_name"));
	SetProperty ("level_long_name:label.text", "|000000|"..GetGameValue ("level_long_name"));

  StopMusic (3.0); -- the parm is the fade out time
	PlaySound ("music/levelstart.ogg");
	
	timer = 0;
end;

function OnLeave ()
end;


function OnClick (name)

	
	
end;

function OnKeyDown (key)
	Print("Any Key Down\n");
	-- any key speeds up leaving this screen
	if (delay_time > 3.05 and Azkend_IsTalismanAnimComplete ()) then
		SetProperty ("/LevelStart:leave_trans_duration", 0.25);
		timer = 100; -- just enough so it'll exit this screen at OnUpdate
	end;

end;


function OnUpdate (tdelta)

  y_offset = 0;

	akey = GetActiveScreenAnimKey ();
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
  
  if (timer < delay_time) then
  	y_offset = 150;
  else
  	y_offset = 150 * trans;
  end;
  
  SetProperty ("/Game/GameBar:position_offset.y", 200);-- y_offset);

  timer = timer + tdelta;
  if (timer > delay_time and Azkend_IsTalismanAnimComplete ()) then
    PopScreen ("LevelStart");
  end;


	--SetProperty ("panel:position_offset.y", (1-trans) * 20);
	SetProperty ("panel:alpha", trans);
	--SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

end;

function OnDraw ()

	alpha = GetActiveScreenTransPhase ();
	--NX_DrawBitmapRS ("", 800/2, 600/2+100, 0, 1);



end;
